﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace kr.co.daims.DisplayComponents.ChartGroup3.HeadingIndicatorView
{
    /// <summary>
    /// @작성자: 최동희(2019.10.10)
    /// Console Debug 메시지를 다양한 색상을 이용하여 표시하기 위한 클래스.
    /// </summary>
    public static class CDebug
    {
        /// <summary>
        /// Method 정보를 포함하는 메시지를 출력하기 위한 출력함수.
        /// </summary>
        /// <param name="methodName"></param>
        /// <param name="msg"></param>
        /// <param name="color"></param>
        static public void WriteLine(string methodName, string msg, ConsoleColor color = ConsoleColor.White)
        {
            Console.ForegroundColor = ConsoleColor.Green;
            Console.Write($"[{DateTime.Now.ToShortTimeString()}][{methodName}] ");
            Console.ForegroundColor = color;
            Console.WriteLine(msg);
            Console.ResetColor();
        }

        /// <summary>
        /// 메시지를 출력하기 위한 출력함수.(Text 기본 컬러는 White)
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="color"></param>
        static public void WriteLine(string msg, ConsoleColor color = ConsoleColor.White)
        {
            Console.ForegroundColor = color;
            Console.WriteLine(msg);
            Console.ResetColor();
        }

        /// <summary>
        /// Trace 메시지를 출력하기 위한 출력함수.(Text 기본 컬러는 Green)
        /// </summary>
        /// <param name="methodName"></param>
        /// <param name="msg"></param>
        /// <param name="color"></param>
        static public void WriteTrace(string msg, ConsoleColor color = ConsoleColor.Green)
        {
#if (TRACE)
            WriteLine($"[{DateTime.Now.ToShortTimeString()}][Trace] {msg}", color);
#endif
        }

        /// <summary>
        /// Method 정보를 포함하는 Trace 메시지를 출력하기 위한 출력함수.(Text 기본 컬러는 Red)
        /// </summary>
        /// <param name="methodName"></param>
        /// <param name="msg"></param>
        /// <param name="color"></param>
        static public void WriteTrace(string methodName, string msg, ConsoleColor color = ConsoleColor.Red)
        {
            WriteLine(methodName, msg, color);
        }

        /// <summary>
        /// Debug 메시지를 출력하기 위한 출력함수.(Text 기본 컬러는 Yellow)
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="color"></param>

        static public void WriteDebug(string msg, ConsoleColor color = ConsoleColor.Yellow)
        {
#if (DEBUG)
            WriteLine($"[{DateTime.Now.ToShortTimeString()}][Debug] {msg}", color);
#endif
        }

        /// <summary>
        /// Method 정보를 포함하는 Debug 메시지를 출력하기 위한 출력함수.(Text 기본 컬러는 Yellow)
        /// </summary>
        /// <param name="methodName"></param>
        /// <param name="msg"></param>
        /// <param name="color"></param>
        static public void WriteDebug(string methodName, string msg, ConsoleColor color = ConsoleColor.Yellow)
        {
            WriteLine(methodName, msg, color);
        }

        /// <summary>
        /// 에러메시지를 출력하기 위한 출력함수.(Text 기본 컬러는 Red)
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="color"></param>
        static public void WriteError(string msg, ConsoleColor color = ConsoleColor.Red)
        {
            WriteLine($"[{DateTime.Now.ToShortTimeString()}][Error] {msg}", color);
        }

        /// <summary>
        /// Method 정보를 포함하는 에러메시지를 출력하기 위한 출력함수.(Text 기본 컬러는 Red)
        /// </summary>
        /// <param name="methodName"></param>
        /// <param name="msg"></param>
        /// <param name="color"></param>
        static public void WriteError(string methodName, string msg, ConsoleColor color = ConsoleColor.Red)
        {
            WriteLine(methodName, msg, color);
        }
    }
}
