﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using SharpDX.Direct2D1;
using SharpDX;
using System.Globalization;
using System.Reflection;
using System.IO;
using System.Text.RegularExpressions;

namespace kr.co.daims.DisplayComponents.ChartGroup3.StandardGaugeView
{
    using Brush = SharpDX.Direct2D1.Brush;
    using RectangleF = SharpDX.RectangleF;
    using TextFormat = SharpDX.DirectWrite.TextFormat;
    using TextLayout = SharpDX.DirectWrite.TextLayout;
    public partial class StandardGaugeControl : UserControl
    {

        #region [ 전역 상수 ]
        /// <summary>
        /// 클래스내에서 문자열 포멧팅에 사용되는 전역 문자열 버퍼
        /// </summary>
        private StringBuilder strFormatter = null;
        /// <summary>
        /// face 크기는 Casting 크기의 95%
        /// </summary>
        private float faceSizeRatio = 0.04f;

        private float startDeg = 225;
        #endregion

        #region [ 전역 변수 ]
        private float planeScaleX = 1;
        private float planeScaleY = 1;
        private System.Drawing.PointF origin;
        private struct State
        {
            public float CurrentValue;
            public int Precision;
            public float SweepAngle;
            public float RangeStart;
            public float RangeEnd;
            public Brush NormalRangeBrush, AlarmRangeBrush, WarningRangeBrush, CircleBrush, NeedleBrush, CurrentValueBrush, RangeValueBrush;
            public double NormalMin, NormalMax, AlarmMin, AlarmMax, WarningMin, WarningMax;
            // ValueFont : 현재값 표시 폰트,  AzimuthFont :방위각 표시 폰트
            public TextFormat CurrentValueFont, GaugeTextFont;

            public bool IsShowValue;
        };

        State mState;
        bool mIsOnBatchMode = false;

        WindowRenderTarget mRenderTarget;
        public SharpDX.DirectWrite.Factory mFontFactory = new SharpDX.DirectWrite.Factory(SharpDX.DirectWrite.FactoryType.Shared);


        public float CurrentValue
        {
            get { return mState.CurrentValue; }
            set
            {
                mState.CurrentValue = value;
                Redraw();
            }
        }

        #region [ NormalRangeBrush ] 
        private Color normalRangeColor;
        public Brush NormalRangeBrush
        {
            get { return mState.NormalRangeBrush; }
            set
            {
                mState.NormalRangeBrush = value;
                Redraw();
            }
        }
        public Color NormalRangeColor
        {
            get
            {
                return normalRangeColor;
            }
            set
            {
                normalRangeColor = value;
                if (mRenderTarget != null)
                {
                    NormalRangeBrush = new SolidColorBrush(mRenderTarget, normalRangeColor);
                }
            }
        }
        #endregion

        #region [ AlarmRangeBrush ] 
        private Color alarmRangeColor;
        public Brush AlarmRangeBrush
        {
            get { return mState.AlarmRangeBrush; }
            set
            {
                mState.NormalRangeBrush = value;
                Redraw();
            }
        }
        public Color AlarmRangeColor
        {
            get
            {
                return alarmRangeColor;
            }
            set
            {
                alarmRangeColor = value;
                if (mRenderTarget != null)
                {
                    AlarmRangeBrush = new SolidColorBrush(mRenderTarget, alarmRangeColor);
                }
            }
        }
        #endregion


        #region [ WarningRangeBrush ] 
        private Color warningRangeColor;
        public Brush WarningRangeBrush
        {
            get { return mState.WarningRangeBrush; }
            set
            {
                mState.NormalRangeBrush = value;
                
                Redraw();
            }
        }
        public Color WarningRangeColor
        {
            get
            {
                return warningRangeColor;
            }
            set
            {
                warningRangeColor = value;
                if (mRenderTarget != null)
                {
                    WarningRangeBrush = new SolidColorBrush(mRenderTarget, warningRangeColor);
                }
            }
        }
        #endregion

        #region [ CircleBrush ] 
        private Color circleColor;
        public Brush CircleBrush
        {
            get { return mState.CircleBrush; }
            set
            {
                mState.NormalRangeBrush = value;
                Redraw();
            }
        }
        public Color CircleColor
        {
            get
            {
                return circleColor;
            }
            set
            {
                circleColor = value;
                if (mRenderTarget != null)
                {
                    CircleBrush = new SolidColorBrush(mRenderTarget, circleColor);
                }
            }
        }
        #endregion

        #region [ NeedleBrush ] 
        private Color needleColor;
        public Brush NeedleBrush
        {
            get { return mState.NeedleBrush; }
            set
            {
                mState.NeedleBrush = value;
                Redraw();
            }
        }
        public Color NeedleColor
        {
            get
            {
                return warningRangeColor;
            }
            set
            {
                needleColor = value;
                if (mRenderTarget != null)
                {
                    NeedleBrush = new SolidColorBrush(mRenderTarget, needleColor);
                }
            }
        }
        #endregion

        #region [ CurrentValueBrush ] 
        private Color currentValueColor;
        public Brush CurrentValueBrush
        {
            get { return mState.CurrentValueBrush; }
            set
            {
                mState.CurrentValueBrush = value;
                Redraw();
            }
        }
        public Color CurrentValueColor
        {
            get
            {
                return warningRangeColor;
            }
            set
            {
                currentValueColor = value;
                if (mRenderTarget != null)
                {
                    CurrentValueBrush = new SolidColorBrush(mRenderTarget, currentValueColor);
                }
            }
        }
        #endregion
        public int Precision
        {
            get
            {
                return mState.Precision;
            }
            set
            {
                mState.Precision = value;
                Redraw();
            }
        }
        public float SweepAngle
        {
            get
            {
                return mState.SweepAngle;
            }
            set
            {
                mState.SweepAngle = value;
                Redraw();
            }
        }
        public float RangeStart
        {
            get
            {
                return mState.RangeStart;
            }
            set
            {
                mState.RangeStart = value;
                Redraw();
            }
        }
        public float RangeEnd
        {
            get
            {
                return mState.RangeStart;
            }
            set
            {
                mState.RangeStart = value;
                Redraw();
            }
        }
        public new TextFormat CurrentValueFont
        {
            get { return mState.CurrentValueFont; }
            set
            {
                mState.CurrentValueFont = value;
                Redraw();
            }
        }

        public new TextFormat GaugeTextFont
        {
            get { return mState.GaugeTextFont; }
            set
            {
                mState.GaugeTextFont = value;
                Redraw();
            }
        }


        #endregion

        #region [ 이벤트 ]
        public delegate void BatchRun(StandardGaugeControl control);
        #endregion
        public StandardGaugeControl()
        {

            strFormatter = new StringBuilder(1000);
            InitializeComponent();
            SharpDX.Configuration.EnableObjectTracking = true;
            NormalRangeColor = Color.Red;
            AlarmRangeColor = Color.Yellow;
            WarningRangeColor = Color.Red;
            CircleColor = Color.Black;
            NeedleColor = Color.Red;
            currentValueColor = Color.Blue;
            mState.SweepAngle = 180;
            mState.Precision = 2;
            origin = new System.Drawing.PointF(0, 0);
        }
        private void OnLoad(object sender, EventArgs e)
        {
            Factory fact = new Factory(FactoryType.MultiThreaded);

            var targetProperties = new RenderTargetProperties(new PixelFormat(SharpDX.DXGI.Format.B8G8R8A8_UNorm, AlphaMode.Premultiplied));
            var hwndProperties = new HwndRenderTargetProperties();
            hwndProperties.Hwnd = mRenderControl.Handle;
            hwndProperties.PixelSize = new SharpDX.Size2(mRenderControl.ClientSize.Width, mRenderControl.ClientSize.Height);
            hwndProperties.PresentOptions = PresentOptions.None;
            mRenderTarget = new WindowRenderTarget(fact, targetProperties, hwndProperties);

            mState.NormalRangeBrush = new SolidColorBrush(mRenderTarget, NormalRangeColor);
            mState.AlarmRangeBrush = new SolidColorBrush(mRenderTarget, AlarmRangeColor);
            mState.WarningRangeBrush = new SolidColorBrush(mRenderTarget, WarningRangeColor);
            mState.CircleBrush = new SolidColorBrush(mRenderTarget, CircleColor);
            mState.NeedleBrush = new SolidColorBrush(mRenderTarget, NeedleColor);
            mState.CurrentValueBrush = new SolidColorBrush(mRenderTarget, currentValueColor);
            mState.RangeValueBrush = new SolidColorBrush(mRenderTarget, Color.SkyBlue);
            mState.RangeStart = 0;
            mState.RangeEnd = 100;


            mState.IsShowValue = true;
            SetText();
        }

        public void Batch(BatchRun run)
        {
            if (run == null)
                return;

            Exception exception = null;

            try
            {
                mIsOnBatchMode = true;
                run(this);
            }
            catch (Exception ex)
            {
                //exception = new Exception("BatchRun threw a exception", e);
                strFormatter.Clear();
                strFormatter.AppendFormat(CultureInfo.CreateSpecificCulture("en-US"), $"{ex.Message} :: {ex.StackTrace}");
            }

            mIsOnBatchMode = false;
            Redraw(true);

            if (exception != null)
                throw exception;
        }

        private void Redraw(bool forced = false)
        {
            if (!mIsOnBatchMode || forced)
                mRenderControl.Invalidate();
        }
        public double DegToRad(double rad)
        {
            return Math.PI * rad / 180.0;
        }
        private void Render(WindowRenderTarget target, int width, int height)
        {
            try
            {
                //width = (int)(width * 0.8);
                //height = (int)(height * 0.8);
                var diameter = Math.Min(width, height);

                target.Resize(new Size2(width, height));
                target.BeginDraw();
                //배경색을 희색으로 클리어
                target.Clear(SharpDX.Color.White);
                //======================================================
                float widthRadius = width / 2.0f;
                float heightRadius = height / 2.0f;
                var radius = diameter / 2;
                planeScaleX = width / 200.0f * 0.2f;
                planeScaleY = height / 200.0f * 0.2f;

                var centerVector = new Vector2(widthRadius, height / 2);
                var castingWidth = widthRadius * faceSizeRatio;
                // 눈금의 너비
                var graduationWidth = widthRadius * 0.005f;
                target.Transform = Matrix3x2.Identity;
                var t = target.Transform;
                target.Transform = t;
                using (var layer = new Layer(target))
                {
                    var layerParam = new LayerParameters()
                    {
                        ContentBounds = new RectangleF(0, 0, width, height)
                        ,
                        Opacity = 1.0f
                    };

                    //Face Ellipse를 그림
                    target.FillEllipse(new Ellipse(centerVector, widthRadius - 2, heightRadius - 2), mState.CircleBrush);

                    #region [Normal Range ]
                    while (true)
                    {
                        var normalRangeArcGeo = new PathGeometry(target.Factory);
                        double startDegree = DegToRad(startDeg);//225
                        double midDegree = DegToRad((startDeg - mState.SweepAngle)/2);
                        double endDegree = DegToRad(startDeg - mState.SweepAngle);

                        target.Transform = Matrix3x2.Identity;
                        {
                            Func<float, float, float, Vector2> rotate = (x, y, degree) =>
                            {
                                var rad = MathUtil.DegreesToRadians(degree);
                                var matrix = Matrix3x2.Translation(x, y) * Matrix3x2.Rotation(rad, new Vector2(widthRadius, heightRadius));
                                return matrix.Row3;
                            };

                            var startPos = rotate(radius, 0, 0);
                            var angle = 360.0f;
                            using (var sink = normalRangeArcGeo.Open())
                            {
                                var arc = new ArcSegment()
                                {
                                    ArcSize = ArcSize.Small,
                                    RotationAngle = 0,
                                    Size = new Size2F(radius, radius),
                                    SweepDirection = SweepDirection.Clockwise
                                };
                                sink.BeginFigure(startPos, FigureBegin.Filled);
                                arc.Point = rotate(radius, 0, angle / 2);
                                sink.AddArc(arc);
                                arc.Point = rotate(radius, 0, angle);
                                sink.AddArc(arc);
                                sink.EndFigure(FigureEnd.Open);
                                sink.Close();
                            }

                            target.DrawGeometry(normalRangeArcGeo, mState.NormalRangeBrush, (widthRadius * 0.1f));
                        }
                        break;
                        float startX = widthRadius + ((float)Math.Cos(startDegree) * widthRadius * 0.95f);
                        float startY = heightRadius - ((float)Math.Sin(startDegree) * heightRadius * 0.95f);

                        float endX = widthRadius + ((float)Math.Cos(endDegree) * widthRadius * 0.95f);
                        float endY = heightRadius - ((float)Math.Sin(endDegree) * heightRadius * 0.95f);
                        Vector2 off = new Vector2(startX, startY);
                        using (var sink = normalRangeArcGeo.Open())
                        {
                            var arc = new ArcSegment()
                            {
                                ArcSize = ArcSize.Small,
                                RotationAngle = mState.SweepAngle,
                                Point = off,
                                Size = new Size2F(widthRadius * 0.95f, heightRadius * 0.95f),
                                SweepDirection = SweepDirection.CounterClockwise
                            };

                            sink.BeginFigure(new Vector2(endX, endY), FigureBegin.Filled);
                            sink.AddArc(arc);
                            sink.EndFigure(FigureEnd.Open);
                            sink.Close();
                        }
                        //CDebug.WriteTrace($"ARC :[[{width}  == {height}]] [{Math.Cos(Math.PI * 225 / 180.0)}]{startX} - [{Math.Sin(Math.PI * 225 / 180.0)}]{startY} , [{Math.Cos(Math.PI * 90 / 180.0)}]{endX} - [{Math.Sin(Math.PI * 90 / 180.0)}]{endY}");
                        target.DrawGeometry(normalRangeArcGeo, mState.NormalRangeBrush, (widthRadius * 0.1f));
                    }
                    #endregion
                    #region [Alarm Range ] 
                    {
                        //double startDegree = DegToRad(90);
                        //double endDegree = DegToRad(0);

                        //float startX = widthRadius + ((float)Math.Cos(startDegree) * widthRadius * 0.95f);
                        //float startY = heightRadius - ((float)Math.Sin(startDegree) * heightRadius * 0.95f);

                        //float endX = widthRadius + ((float)Math.Cos(endDegree) * widthRadius * 0.95f);
                        //float endY = heightRadius - ((float)Math.Sin(endDegree) * heightRadius * 0.95f);
                        //Vector2 off = new Vector2(startX, startY);
                        //var normalRangeArc = new ArcSegment()
                        //{
                        //    ArcSize = ArcSize.Small,
                        //    RotationAngle = 135,
                        //    Point = off,
                        //    Size = new Size2F(widthRadius * 0.95f, heightRadius * 0.95f),
                        //    SweepDirection = SweepDirection.CounterClockwise
                        //};

                        //using (var shink = normalRangeArcGeo.Open())
                        //{

                        //    shink.BeginFigure(new SharpDX.Mathematics.Interop.RawVector2(endX, endY), FigureBegin.Filled);
                        //    shink.AddArc(normalRangeArc);
                        //    shink.EndFigure(FigureEnd.Open);
                        //    shink.Close();
                        //}
                        ////CDebug.WriteTrace($"ARC :[[{width}  == {height}]] [{Math.Cos(Math.PI * 225 / 180.0)}]{startX} - [{Math.Sin(Math.PI * 225 / 180.0)}]{startY} , [{Math.Cos(Math.PI * 90 / 180.0)}]{endX} - [{Math.Sin(Math.PI * 90 / 180.0)}]{endY}");
                        //target.DrawGeometry(normalRangeArcGeo, mState.AlarmRangeBrush, (widthRadius * 0.1f));
                    }
                    #endregion


                    #region [Warning Range ] 
                    {
                        //double startDegree = DegToRad(0);
                        //double endDegree = DegToRad(-30);

                        //float startX = widthRadius + ((float)Math.Cos(startDegree) * widthRadius * 0.95f);
                        //float startY = heightRadius - ((float)Math.Sin(startDegree) * heightRadius * 0.95f);

                        //float endX = widthRadius + ((float)Math.Cos(endDegree) * widthRadius * 0.95f);
                        //float endY = heightRadius - ((float)Math.Sin(endDegree) * heightRadius * 0.95f);
                        //Vector2 off = new Vector2(startX, startY);
                        //var normalRangeArc = new ArcSegment()
                        //{
                        //    ArcSize = ArcSize.Small,
                        //    RotationAngle = 135,
                        //    Point = off,
                        //    Size = new Size2F(widthRadius * 0.95f, heightRadius * 0.95f),
                        //    SweepDirection = SweepDirection.CounterClockwise
                        //};

                        //using (var shink = normalRangeArcGeo.Open())
                        //{

                        //    shink.BeginFigure(new SharpDX.Mathematics.Interop.RawVector2(endX, endY), FigureBegin.Filled);
                        //    shink.AddArc(normalRangeArc);
                        //    shink.EndFigure(FigureEnd.Open);
                        //    shink.Close();
                        //}
                        ////CDebug.WriteTrace($"ARC :[[{width}  == {height}]] [{Math.Cos(Math.PI * 225 / 180.0)}]{startX} - [{Math.Sin(Math.PI * 225 / 180.0)}]{startY} , [{Math.Cos(Math.PI * 90 / 180.0)}]{endX} - [{Math.Sin(Math.PI * 90 / 180.0)}]{endY}");
                        //target.DrawGeometry(normalRangeArcGeo, mState.WarningRangeBrush, (widthRadius * 0.1f));
                    }
                    #endregion

                    #region [ Value 표시]
                    // target.Transform = Matrix3x2.Identity;
                    // target.PushLayer(ref layerParam, layer);

                    //using (var azimuthText = new TextLayout(mFontFactory, "1111", mState.GaugeTextFont, 300, 300))
                    //{
                    //    target.DrawTextLayout(new Vector2(100, 100), azimuthText, mState.RangeValueBrush);
                    //}



                    //==================================
                    //float gaugeEndDeg = startDeg - SweepAngle;
                    //float degStep = SweepAngle / 10;
                    //Console.WriteLine($"{widthRadius}   {heightRadius}");
                    //for (float i = 0; i < 10; i++)
                    //{
                    //    string valueString = (mState.RangeStart + (degStep * i)).ToString();
                    //    float deg = startDeg - (degStep * i);
                    //    deg = 450 - deg;
                    //    float posX = widthRadius - ((float)Math.Cos(deg) * widthRadius * 0.7f);
                    //    float posY = heightRadius - ((float)Math.Sin(deg) * heightRadius * 0.7f);
                    //    using (var azimuthText = new TextLayout(mFontFactory, valueString, mState.GaugeTextFont, 300, 300))
                    //    {
                    //        target.DrawTextLayout(new Vector2(posX, posY), azimuthText, mState.RangeValueBrush);
                    //    }
                    //    //Console.WriteLine($"{valueString}  \t==> {deg},\t {posX},\t  {posX}    ==>{deg} \t {Math.Cos(deg)}    {Math.Sin(deg)}");
                    //}

                    // target.Transform = Matrix3x2.Rotation(MathUtil.DegreesToRadians(mState.CurrentValue), new Vector2(width / 2, height / 2));
                    //target.PushLayer(ref layerParam, layer);

                    var innerRadius = radius * 0.7f;

                    target.Transform = Matrix3x2.Identity;
                    target.DrawLine(new Vector2(width / 2, 0), new Vector2(width / 2, height), new SolidColorBrush(mRenderTarget, Color.White));
                    target.DrawLine(new Vector2(0, height / 2), new Vector2(width, height / 2), new SolidColorBrush(mRenderTarget, Color.White));
                    target.DrawEllipse(new Ellipse(centerVector, innerRadius, innerRadius), new SolidColorBrush(mRenderTarget, Color.White));

                    //==================================
                    for (float i = 0; i < 360; i += 45.0f)
                    {
                        #region [ CurrValue 적용 파트 ] 
                        // Azimuth 각도에 따라 회전하는 기능이 필요한 부분
                        target.Transform = Matrix3x2.Rotation(MathUtil.DegreesToRadians(-i));
                        target.Transform *= Matrix3x2.Translation(innerRadius, 0);
                        target.Transform *= Matrix3x2.Rotation(MathUtil.DegreesToRadians(i + mState.CurrentValue));//, new Vector2(width / 2, height / 2));
                        target.Transform *= Matrix3x2.Translation(radius, radius);
                        //target.Transform *= Matrix3x2.Rotation(MathUtil.DegreesToRadians(i + mState.CurrentValue), new Vector2(width / 2, height / 2));
                        string valueString = i.ToString();
                        using (var azimuthText = new TextLayout(mFontFactory, valueString, mState.GaugeTextFont, 300, 300))
                        {
                            var pos = new Vector2(azimuthText.Metrics.Width, azimuthText.Metrics.Height) / -2;
                            target.DrawRectangle(new RectangleF(pos.X, pos.Y, azimuthText.Metrics.Width, azimuthText.Metrics.Height), new SolidColorBrush(mRenderTarget, Color.Green));
                            target.DrawTextLayout(pos, azimuthText, mState.RangeValueBrush);
                            //target.DrawTextLayout(new Vector2(), azimuthText, mState.RangeValueBrush);
                        }
                        continue;
                        //if (i % 30 == 0)
                        //{
                        //    // 0,90,180,270도일때 각각 N, E, S, W 를 표시. 나머지 각에서는 30도 단위로 3,6,12,15,21,24,30,33을 표시
                        //    string valueString = i.ToString();

                        //    using (var azimuthText = new TextLayout(mFontFactory, valueString, mState.GaugeTextFont, 300, 300))
                        //    {
                        //        //target.DrawTextLayout(new Vector2((width - azimuthText.Metrics.Width) / 2, heightRadius * 0.2f), azimuthText, mState.RangeValueBrush);
                        //        target.DrawTextLayout(new Vector2(), azimuthText, mState.RangeValueBrush);
                        //    }
                        //}
                        #endregion
                    }
                    //target.PopLayer();


                    //=============================



                    //for(float i = startDeg; i > gaugeEndDeg; degStep += degStep)
                    //{

                    //    using (var azimuthText = new TextLayout(mFontFactory, valueString, mState.AzimuthFont, 300, 300))
                    //    {
                    //        target.DrawTextLayout(new Vector2((width - azimuthText.Metrics.Width) / 2, heightRadius * 0.2f), azimuthText, mState.CircleBrush);
                    //    }
                    //}
                    //for (float i = 0; i < 360; i += 2.5f)
                    //{
                    //    #region [ CurrValue 적용 파트 ] 
                    //    // Azimuth 각도에 따라 회전하는 기능이 필요한 부분
                    //    var radius = diameter / 2;
                    //    target.Transform = Matrix3x2.Rotation(DegToRad(i + mState.CurrentValue), new Vector2(width / 2, height / 2));

                    //    //target.DrawLine(new Vector2(width / 2, radius * 0.1f), new Vector2(width / 2, radius * (i % 5 == 0 ? 0.18f : 0.15f)), mState.LineBrush, (i % 5 == 0 ? graduationWidth * 2f : graduationWidth));
                    //    if (i % 30 == 0)
                    //    {
                    //        // 0,90,180,270도일때 각각 N, E, S, W 를 표시. 나머지 각에서는 30도 단위로 3,6,12,15,21,24,30,33을 표시
                    //        string valueString = i % 90 == 0 ? Direction[(int)(i / 90)].ToString() : ((int)(i / 30) * 3).ToString();

                    //        using (var azimuthText = new TextLayout(mFontFactory, valueString, mState.AzimuthFont, 300, 300))
                    //        {
                    //            target.DrawTextLayout(new Vector2((width - azimuthText.Metrics.Width) / 2, heightRadius * 0.2f), azimuthText, mState.CircleBrush);
                    //        }
                    //    }
                    //    #endregion
                    //}
                    // target.PopLayer();
                    #endregion

                }




                target.Flush();
                target.EndDraw();
                Console.WriteLine($"Draw Update {mState.CurrentValue}");
            }
            catch (Exception ex)
            {
                strFormatter.Clear();
                strFormatter.AppendFormat(CultureInfo.CreateSpecificCulture("en-US"), $"{ex.Message} :: {ex.StackTrace}");
            }

        }


        private void OnResize(object sender, EventArgs e)
        {
            Redraw(true);
            SetText();
        }



        private void OnPaint(object sender, PaintEventArgs e)
        {
            Render(mRenderTarget, mRenderControl.ClientSize.Width, mRenderControl.ClientSize.Height);
        }

        #region [ Mouse Event ] 
        private void mRenderControl_MouseDown(object sender, MouseEventArgs e)
        {
            base.OnMouseDown(e);
        }

        private void mRenderControl_MouseUp(object sender, MouseEventArgs e)
        {
            base.OnMouseUp(e);
        }

        private void mRenderControl_MouseMove(object sender, MouseEventArgs e)
        {
            base.OnMouseMove(e);
        }

        private void mRenderControl_Resize(object sender, EventArgs e)
        {
            Redraw(true);

        }

        private void mRenderControl_DragEnter(object sender, DragEventArgs e)
        {
            base.OnDragEnter(e);
        }

        private void mRenderControl_DragDrop(object sender, DragEventArgs e)
        {
            base.OnDragDrop(e);
        }
        #endregion

        #region [ 사용자 함수]

        /// <summary>
        /// 방위각 Text 및 현재값 Text 를 업데이트 하기 위한 함수.
        /// 컴포넌트 크기에 따른  Text 동적 크기 설정.
        /// </summary>
        private void SetText()
        {
            var newSize = 10 + 2 * (this.Size.Width / 60);
            if (this.mState.CurrentValueFont == null || this.mState.CurrentValueFont.FontSize != newSize)
            {
                this.mState.CurrentValueFont = new TextFormat(mFontFactory, "", newSize);
                //this.mState.ValueFont = new TextFormat(mFontFactory, "", newSize);
            }
            if(this.mState.GaugeTextFont == null || this.mState.GaugeTextFont.FontSize != newSize)
            {
                this.mState.GaugeTextFont = new TextFormat(mFontFactory, "", newSize);
            }
        }

        #endregion
    }
}

